<?php

/**
 * Elementor Single Widget
 * @package Papurfy Extension
 * @since 1.0.0
 */

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly.

class magezix_breadcrumb_widget extends Widget_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve Elementor widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mgz-breadcrumb-title';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve Elementor widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return esc_html__( 'Magezix Breadcrumb', 'magezix-core' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Elementor widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'mg-custom-icon';
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the Elementor widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'magezix_widgets' ];
	}



	protected function render() {
		$settings = $this->get_settings_for_display();		

    ?>

    <section class="breadcrumb-area">
        <div class="magezix-breadcrumb breadcrumbs">
            <?php 
            if(function_exists('bcn_display')){
                bcn_display();
            }else{ ?>
                <ul class="list-unstyled ul_li">
                    <?php echo magezix_the_breadcrumb();?>
                </ul>
            <?php }
            ?>                
        </div>
    </section>
    <?php 
    }
		
	
}


Plugin::instance()->widgets_manager->register( new magezix_breadcrumb_widget() );