;(function($) {
    'use strict';

    // Assign the appropriate value to the 'elementor' variable
    var elementor = window.elementor;

    // Check if 'elementor' is defined before using it
    if (typeof elementor !== 'undefined') {
        elementor.on('panel:init', function() {
            $('#elementor-panel-elements-search-input').on('keyup', _.debounce(function() {
                $('#elementor-panel-elements')
                    .find('.hm')
                    .parents('.elementor-element')
                    .addClass('is-elementhelper-widget');
            }, 100));

            // Element helper Grid Layer Shortcut Register
            if (typeof $e !== 'undefined' && $e !== null) {
                var option = {
                    callback: function() {
                        var elh_element_grid = elementor.settings.page.model.attributes.elh_element_grid;
                        if ('' === elh_element_grid) {
                            elementor.settings.page.model.setExternalChange('elh_element_grid', 'yes');
                        } else if ('yes' === elh_element_grid) {
                            elementor.settings.page.model.setExternalChange('elh_element_grid', '');
                        }
                    }
                };

                $e.shortcuts.register('ctrl+shift+g', option);
                $e.shortcuts.register('cmd+shift+g', option);
            }

            function getCssEffectsControlsMap() {
                return {
                    'translate': ['x', 'y', 'x_tablet', 'y_tablet', 'x_mobile', 'y_mobile'],
                    'skew': ['x', 'y', 'x_tablet', 'y_tablet', 'x_mobile', 'y_mobile'],
                    'scale': ['x', 'y', 'x_tablet', 'y_tablet', 'x_mobile', 'y_mobile'],
                    'rotate': ['x', 'y', 'z', 'x_tablet', 'y_tablet', 'z_tablet', 'x_mobile', 'y_mobile', 'z_mobile']
                };
            }

            function bindCssTransformControls(effectSwitch, effectControl, widgetModel) {
                var settingPrefix = 'elh_element_transform_fx_';
                effectSwitch = settingPrefix + effectSwitch;
                effectControl = settingPrefix + effectControl;

                widgetModel.on('change:' + effectSwitch, function(model, isActive) {
                    if (!isActive) {
                        var controlView = elementor.getPanelView().getCurrentPageView().children.find(function(view) {
                            return view.model.get('name') === effectControl;
                        });
                        widgetModel.set(effectControl, _.extend({}, widgetModel.defaults[effectControl]));
                        controlView && controlView.render();
                    }
                });
            }

            function initCssTransformEffects(model) {
                var widgetModel = elementorFrontend.config.elements.data[model.cid];
                _.each(getCssEffectsControlsMap(), function(effectProps, effectKey) {
                    _.each(effectProps, function(effectProp) {
                        bindCssTransformControls(
                            effectKey + '_toggle',
                            effectKey + '_' + effectProp,
                            widgetModel
                        );
                    })
                });

                // Event bindings cleanup
                elementor.getPanelView().getCurrentPageView().model.on('editor:close', function() {
                    _.each(getCssEffectsControlsMap(), function(effectConfig, effectKey) {
                        widgetModel.off('change:elh_element_transform_fx_' + effectKey + '_toggle');
                    });
                });
            }

            elementor.hooks.addAction('panel/open_editor/widget', function(panel, model) {
                initCssTransformEffects(model);
            });

            if (elementor.modules.controls.Icons) {
                var WithElementHelperIcons = elementor.modules.controls.Icons.extend({
                    // Rest of the code...
                });

                elementor.addControlView('icons', WithElementHelperIcons);
            }

            window.elh_element_has_icon_library = function() {
                return (elementor.helpers && elementor.helpers.renderIcon);
            };

            window.elh_element_get_feature_label = function(text) {
                var div = document.createElement('DIV');
                div.innerHTML = text;
                text = div.textContent || div.innerText || text;
                return text.length > 20 ? text.substring(0, 20) + "..." : text;
            };

            function elh_element_translate(stringKey, templateArgs) {
                return elementorCommon.translate(stringKey, null, templateArgs, WithElementHelperIcons.i18n);
            }

            elementor.modules.layouts.panel.pages.menu.Menu.addItem({
                // Rest of the code...
            }, 'settings');

            elementor.modules.layouts.panel.pages.menu.Menu.addItem({
                // Rest of the code...
            }, 'settings');
        });
    }
})(jQuery);
