<?php
add_action( 'acf/include_fields', function() {
	if ( ! function_exists( 'acf_add_local_field_group' ) ) {
		return;
	}
	acf_add_local_field_group( array(
		'key' => 'group_5f3a285472b72',
		'title' => 'Author Info',
		'fields' => array(
			array(
				'key' => 'field_5f3a3740d496c',
				'label' => 'Written by',
				'name' => 'meno_write_by',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => 'Author:',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_6186b9a88a827',
				'label' => 'Author Social Switcher (On/Off)',
				'name' => 'author_social_switcher',
				'aria-label' => '',
				'type' => 'true_false',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'message' => '',
				'default_value' => 1,
				'ui' => 1,
				'ui_on_text' => 'Show',
				'ui_off_text' => 'Hide',
			),
			array(
				'key' => 'field_5f3a28b84077d',
				'label' => 'Facebook',
				'name' => 'meno_facebook',
				'aria-label' => '',
				'type' => 'url',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_6186b9a88a827',
							'operator' => '==',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
			),
			array(
				'key' => 'field_5f3a2eb908256',
				'label' => 'Twitter',
				'name' => 'meno_twitter',
				'aria-label' => '',
				'type' => 'url',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_6186b9a88a827',
							'operator' => '==',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
			),
			array(
				'key' => 'field_5f3a2eb708255',
				'label' => 'Linkedin',
				'name' => 'meno_linkedin',
				'aria-label' => '',
				'type' => 'url',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_6186b9a88a827',
							'operator' => '==',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
			),
			array(
				'key' => 'field_5f3a2eb608254',
				'label' => 'Instagram',
				'name' => 'meno_instagram',
				'aria-label' => '',
				'type' => 'url',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_6186b9a88a827',
							'operator' => '==',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
			),
			array(
				'key' => 'field_5f3a2eb408252',
				'label' => 'Youtube',
				'name' => 'meno_youtube',
				'aria-label' => '',
				'type' => 'url',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_6186b9a88a827',
							'operator' => '==',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'user_form',
					'operator' => '==',
					'value' => 'all',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
	) );

	acf_add_local_field_group( array(
		'key' => 'group_5ee5f5398c424',
		'title' => 'Gallery Post Formatted',
		'fields' => array(
			array(
				'key' => 'field_5ee5f56ae8e7a',
				'label' => 'Gallery Images',
				'name' => 'gallery_images',
				'aria-label' => '',
				'type' => 'photo_gallery',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'fields[gallery_images' => array(
					'edit_modal' => 'Default',
					'images_limit' => '',
				),
				'edit_modal' => 'Default',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'gallery',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => false,
	) );

	acf_add_local_field_group( array(
		'key' => 'group_6287d8e3b8ba6',
		'title' => 'Newsletter Widget',
		'fields' => array(
			array(
				'key' => 'field_62d9915bcc686',
				'label' => 'Facebook',
				'name' => 'facebook',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_62dc05cd8f951',
				'label' => 'Twitter',
				'name' => 'twitter',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_62dc05d68f952',
				'label' => 'Behance',
				'name' => 'behance',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_62dc05dd8f953',
				'label' => 'LinkedIn',
				'name' => 'linkedin',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
			array(
				'key' => 'field_62dc05e48f954',
				'label' => 'Youtube',
				'name' => 'youtube',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'widget',
					'operator' => '==',
					'value' => 'tc_subscriber_widget',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
	) );

	acf_add_local_field_group( array(
		'key' => 'group_5ee5a1f9c8794',
		'title' => 'Page Options',
		'fields' => array(
			array(
				'key' => 'field_62e2d43372648',
				'label' => 'Is Header Position Absolute?',
				'name' => 'is_position_absolute',
				'aria-label' => '',
				'type' => 'true_false',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5ee5b7e62edef',
							'operator' => '==',
							'value' => 'header-style-2',
						),
					),
				),
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'message' => '',
				'default_value' => 0,
				'ui' => 1,
				'ui_on_text' => '',
				'ui_off_text' => '',
			),
			array(
				'key' => 'field_5ee5b7e62edef',
				'label' => 'Header Style',
				'name' => 'ta_header_style',
				'aria-label' => '',
				'type' => 'radio',
				'instructions' => 'Please chose header style.',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '100',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'header-style-1' => '<img src="'.plugins_url( 'assets/img/header/header-1.webp', dirname( __FILE__ ) ).'"><p>Header Style 1:Default</p>',
					'header-style-2' => '<img src="'.plugins_url( 'assets/img/header/header-2.webp', dirname( __FILE__ ) ).'"><p>Header Style 2</p>',
					'header-style-3' => '<img src="'.plugins_url( 'assets/img/header/header-3.webp', dirname( __FILE__ ) ).'"><p>Header Style 3</p>',
					'header-style-4' => '<img src="'.plugins_url( 'assets/img/header/header-4.webp', dirname( __FILE__ ) ).'"><p>Header Style 4</p>',
					'header-style-5' => '<img src="'.plugins_url( 'assets/img/header/header-5.webp', dirname( __FILE__ ) ).'"><p>Header Style 5</p>',
				),
				'default_value' => '',
				'return_format' => 'value',
				'allow_null' => 0,
				'other_choice' => 0,
				'layout' => 'vertical',
				'save_other_choice' => 0,
			),
			array(
				'key' => 'field_5ee5a2875481b',
				'label' => 'Is it invisible breadcrumb?',
				'name' => 'is_it_invisible_breadcrumb',
				'aria-label' => '',
				'type' => 'true_false',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '33',
					'class' => '',
					'id' => '',
				),
				'message' => 'Is it invisible breadcrumb?',
				'default_value' => 0,
				'ui' => 1,
				'ui_on_text' => 'Yes',
				'ui_off_text' => 'No',
			),
			array(
				'key' => 'field_5ee5a3275481c',
				'label' => 'Breadcrumb Background Image',
				'name' => 'breadcrumb_background_image',
				'aria-label' => '',
				'type' => 'image',
				'instructions' => 'Breadcrumb Background Image',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5ee5a2875481b',
							'operator' => '!=',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '33',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'array',
				'preview_size' => 'full',
				'library' => 'all',
				'min_width' => '',
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => 'jpg,png',
			),
			array(
				'key' => 'field_5ee5a3955481d',
				'label' => 'Hide Breadcrumb Background Image',
				'name' => 'hide_breadcrumb_background_image',
				'aria-label' => '',
				'type' => 'true_false',
				'instructions' => 'Hide Breadcrumb Background Image',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_5ee5a2875481b',
							'operator' => '!=',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '33',
					'class' => '',
					'id' => '',
				),
				'message' => 'Hide Breadcrumb Background Image',
				'default_value' => 0,
				'ui' => 1,
				'ui_on_text' => '',
				'ui_off_text' => '',
			),
			array(
				'key' => 'field_5ee5ba74c315f',
				'label' => 'Enable Secondary Logo',
				'name' => 'is_enable_sec_logo',
				'aria-label' => '',
				'type' => 'true_false',
				'instructions' => 'For Enable Secondary Logo Please Go Here',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '33',
					'class' => '',
					'id' => '',
				),
				'message' => '',
				'default_value' => 0,
				'ui' => 1,
				'ui_on_text' => '',
				'ui_off_text' => '',
			),
			array(
				'key' => 'field_610180a83c808',
				'label' => 'Hide Footer',
				'name' => 'hide_footer',
				'aria-label' => '',
				'type' => 'true_false',
				'instructions' => 'Do you want to hide the footer?',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '33',
					'class' => '',
					'id' => '',
				),
				'message' => '',
				'default_value' => 0,
				'ui_on_text' => 'Yes',
				'ui_off_text' => 'No',
				'ui' => 1,
			),
			array(
				'key' => 'field_646520283a517',
				'label' => 'Enable Sticky Footer',
				'name' => 'is_sticky_footer',
				'aria-label' => '',
				'type' => 'true_false',
				'instructions' => 'Do you want to hide the footer?',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '33',
					'class' => '',
					'id' => '',
				),
				'message' => '',
				'default_value' => 0,
				'ui_on_text' => 'Yes',
				'ui_off_text' => 'No',
				'ui' => 1,
			),
			array(
				'key' => 'field_5f0d8782e4a95',
				'label' => 'Footer BG Image',
				'name' => 'ta_footer_bg',
				'aria-label' => '',
				'type' => 'image',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_610180a83c808',
							'operator' => '!=',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '33',
					'class' => '',
					'id' => '',
				),
				'return_format' => 'array',
				'library' => 'all',
				'min_width' => '',
				'min_height' => '',
				'min_size' => '',
				'max_width' => '',
				'max_height' => '',
				'max_size' => '',
				'mime_types' => '',
				'preview_size' => 'medium',
			),
			array(
				'key' => 'field_622cd0d6a635a',
				'label' => 'Footer BG Color',
				'name' => 'ta_footer_bg_color',
				'aria-label' => '',
				'type' => 'color_picker',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_610180a83c808',
							'operator' => '!=',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '25',
					'class' => '',
					'id' => '',
				),
				'default_value' => '#151616',
				'enable_opacity' => 0,
				'return_format' => 'string',
			),
			array(
				'key' => 'field_5efb0ded987fe',
				'label' => 'Footer Style',
				'name' => 'ta_footer_style',
				'aria-label' => '',
				'type' => 'radio',
				'instructions' => 'Please chose footer style.',
				'required' => 0,
				'conditional_logic' => array(
					array(
						array(
							'field' => 'field_610180a83c808',
							'operator' => '!=',
							'value' => '1',
						),
					),
				),
				'wrapper' => array(
					'width' => '100',
					'class' => '',
					'id' => '',
				),
				'choices' => array(
					'footer-style-1' => '<img src="'.plugins_url( 'assets/img/footer/footer-1.webp', dirname( __FILE__ ) ).'"><p>Footer Style 1:Default</p>',
					'footer-style-2' => '<img src="'.plugins_url( 'assets/img/footer/footer-2.webp', dirname( __FILE__ ) ).'"><p>Footer Style 2</p>',
					'footer-style-3' => '<img src="'.plugins_url( 'assets/img/footer/footer-3.webp', dirname( __FILE__ ) ).'"><p>Footer Style 3</p>',
				),
				'default_value' => '',
				'return_format' => 'value',
				'allow_null' => 0,
				'other_choice' => 0,
				'layout' => 'vertical',
				'save_other_choice' => 0,
			),
			array(
				'key' => 'field_646526876e6f7',
				'label' => 'Test',
				'name' => 'test',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'maxlength' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
	) );

	acf_add_local_field_group( array(
		'key' => 'group_5ee5c87c21be4',
		'title' => 'Post Formatted',
		'fields' => array(
			array(
				'key' => 'field_5ee5e1f7dfd22',
				'label' => 'Fromate Link',
				'name' => 'fromate_style',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'maxlength' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'video',
				),
			),
			array(
				array(
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'audio',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
	) );

	acf_add_local_field_group( array(
		'key' => 'group_6447e1098bffc',
		'title' => 'Post Meta',
		'fields' => array(
			array(
				'key' => 'field_6447e109ea06b',
				'label' => 'Post Read Time',
				'name' => 'post_read_time',
				'aria-label' => '',
				'type' => 'text',
				'instructions' => '',
				'required' => 0,
				'conditional_logic' => 0,
				'wrapper' => array(
					'width' => '',
					'class' => '',
					'id' => '',
				),
				'default_value' => '',
				'maxlength' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
			),
		),
		'location' => array(
			array(
				array(
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
				),
			),
		),
		'menu_order' => 0,
		'position' => 'normal',
		'style' => 'default',
		'label_placement' => 'top',
		'instruction_placement' => 'label',
		'hide_on_screen' => '',
		'active' => true,
		'description' => '',
		'show_in_rest' => 0,
	) );
} );
