<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;

use GamxoTheme;
use GamxoTheme_Helper;
use \WP_Query;

$gamxo_has_entry_meta1  = ( $data['post_author'] == 'yes' || $data['post_date'] == 'yes' || $data['post_comment'] == 'yes' || $data['post_length'] == 'yes' && function_exists( 'gamxo_reading_time' ) || $data['post_view'] == 'yes' && function_exists( 'gamxo_views' ) ) ? true : false;

$gamxo_has_entry_meta2  = ( $data['small_post_author'] == 'yes' || $data['small_post_date'] == 'yes' || $data['small_post_comment'] == 'yes' || $data['small_post_length'] == 'yes' && function_exists( 'gamxo_reading_time' ) || $data['small_post_view'] == 'yes' && function_exists( 'gamxo_views' ) ) ? true : false;

$thumb_size = 'gamxo-size5';

$p_ids = array();
foreach ( $data['posts_not_in'] as $p_idsn ) {
    $p_ids[] = $p_idsn['post_not_in'];
}
$args = array(
    'posts_per_page'    => $data['itemlimit']['size'],
    'order'             => $data['post_ordering'],
    'orderby'           => $data['post_orderby'],
    'offset'            => $data['number_of_post_offset'],
    'post__not_in'      => $p_ids,
    'post_type'         => 'post'
);

if(!empty($data['catid'])){
    if( $data['query_type'] == 'category'){
        $args['tax_query'] = [
            [
                'taxonomy' => 'category',
                'field' => 'term_id',
                'terms' => $data['catid'],                    
            ],
        ];

    }
}
if(!empty($data['postid'])){
    if( $data['query_type'] == 'posts'){
        $args['post__in'] = $data['postid'];
    }
}

$query = new WP_Query( $args );
$temp = GamxoTheme_Helper::wp_set_temp_query( $query );

?>

<div class="rt-thumb-slider-default rt-thumb-slider-<?php echo esc_attr( $data['slider_style'] );?> gamxo-vertical-slider">
    <div class="swiper-container vertical-slider" data-xld ="<?php echo esc_attr( $data['swiper_data'] );?>">
        <div class="swiper-wrapper">
        <?php
        if ( $query->have_posts() ) :?>
        <?php while ( $query->have_posts() ) : $query->the_post();?>
        <?php
        
            $content = GamxoTheme_Helper::get_current_post_content();
            $content = wp_trim_words( get_the_excerpt(), $data['count'], '.' );
            $content = "<p>$content</p>";
            $title = wp_trim_words( get_the_title(), $data['title_count'], '' );
            $gamxo_comments_number = number_format_i18n( get_comments_number() );
            $gamxo_comments_html = $gamxo_comments_number == 1 ? esc_html__( 'Comment' , 'gamxo-core' ) : esc_html__( 'Comments' , 'gamxo-core' );
            $gamxo_comments_html = '<span class="comment-number">'. $gamxo_comments_number . '</span> ' . $gamxo_comments_html;
        
            $gamxo_time_html = sprintf( '<span><span>%s </span>%s %s</span>', get_the_time( 'd' ), get_the_time( 'M' ), get_the_time( 'Y' ) );

            $id = get_the_ID();
            $youtube_link = get_post_meta( get_the_ID(), 'gamxo_youtube_link', true );

            ?>
            <div class="swiper-slide">
                <div class="rt-item rt-slide" data-bg-image="<?php echo get_the_post_thumbnail_url(); ?>">
                    <?php if ( ( $data['post_video'] == 'yes' && 'video' == get_post_format( $id ) && !empty( $youtube_link ) ) ) { ?>
                        <div class="rt-video video-btn-wrap position-center"><a class="rt-play play-btn <?php echo esc_attr( $data['play_button_size'] );?> rt-video-popup" href="<?php echo esc_url( $youtube_link );?>"><i class="fas fa-play"></i></a></div>
                    <?php } ?>
                   <div class="container">
                      <div class="row justify-content-between">
                         <div class="col-xl-6 col-lg-8">
                            <div class="entry-content post-content">
                               <?php if ( $data['post_category'] == 'yes' ) { ?>
                                    <?php if ( $data['cat_layout'] == 'cat_layout1' ) { ?>
                                    <span class="entry-categories style-1"><?php echo gamxo_category_prepare(); ?></span>
                                    <?php } elseif ( $data['cat_layout'] == 'cat_layout2' ) { ?>
                                    <span class="entry-categories style-2 meta-light-color"><?php echo the_category( ', ' );?></span>
                                    <?php } ?>
                                <?php } ?>
                                <?php if ( $gamxo_has_entry_meta1 ) { ?>
                                <ul class="entry-meta meta-light-color">
                                    <?php if ( $data['post_date'] == 'yes' ) { ?>   
                                    <li class="post-date"><i class="far fa-calendar-alt"></i><?php echo get_the_date(); ?></li>
                                    <?php } if ( $data['post_author'] == 'yes' ) { ?>
                                    <li class="post-author"><i class="far fa-user"></i><?php esc_html_e( 'by ', 'gamxo' );?><?php the_author_posts_link(); ?></li>  
                                    <?php } if ( $data['post_comment'] == 'yes' ) { ?>
                                    <li class="post-comment"><i class="far fa-comments"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo wp_kses( $gamxo_comments_html , 'alltext_allow' );?></a></li>
                                    <?php } if ( ( $data['post_length'] == 'yes' ) && function_exists( 'gamxo_reading_time' ) ) { ?>
                                    <li class="post-reading-time meta-item"><i class="far fa-clock"></i><?php echo gamxo_reading_time(); ?></li>
                                    <?php } if ( ( $data['post_view'] == 'yes' ) && function_exists( 'gamxo_views' ) ) { ?>
                                    <li><span class="post-views meta-item"><i class="fas fa-signal"></i><?php echo gamxo_views(); ?></span></li>
                                    <?php } ?>
                                </ul>
                                <?php } ?>
                                <h1 class="entry-title title-size-xl title-light-color mb-3"><a href="<?php the_permalink();?>"><?php echo esc_html( $title );?></a></h1>                               
                                <?php if ( $data['content_display'] == 'yes' ) { ?>
                                    <div class="post_excerpt"><?php echo wp_kses_post( $content );?></div>
                                <?php } ?>  
                                <?php if ( $data['post_read'] == 'yes' ) { ?>
                                    <div class="post-read-more"><a class="button-style-1 button-text-light" href="<?php the_permalink();?>"><?php echo wp_kses_post( $data['read_more_text'] ); ?><i class="fas fa-arrow-right"></i></a></div>
                                <?php } ?>
                            </div>
                         </div>
                      </div>
                   </div>
                </div>
            </div>
        <?php endwhile;?>        
        <?php endif;?>
         <!-- end swiper-slide -->
        <?php GamxoTheme_Helper::wp_reset_temp_query( $temp );?>
        </div>
    </div>
    <div class="rt-thumnail-area">
        <div class="container">
            <div class="swiper-container swiper-item-wrap vertical-thumb-slider" data-xld ="<?php echo esc_attr( $data['swiper_data'] );?>">
                <div class="swiper-wrapper">
                    <?php
                    if ( $query->have_posts() ) :?>
                    <?php while ( $query->have_posts() ) : $query->the_post();
                        $small_title = wp_trim_words( get_the_title(), $data['small_title_count'], '' );
                    ?>                   
                    <div class="swiper-slide">
                        <div class="rt-item rt-slide-thumb"> 
                            <div class="rt-image">                           
                                <?php
                                    if ( has_post_thumbnail() ){
                                        the_post_thumbnail( $thumb_size );
                                    } else {
                                        echo '<img class="wp-post-image" src="' . GamxoTheme_Helper::get_asset_file( 'element/noimage_420X420.jpg' ) . '" alt="'.get_the_title().'">';
                                    }
                                ?>
                            </div>
                            <div class="entry-content">                     
                                <?php if ( $data['small_post_category'] == 'yes' ) { ?>
                                    <?php if ( $data['cat_layout'] == 'cat_layout1' ) { ?>
                                    <span class="entry-categories style-1"><?php echo gamxo_category_prepare(); ?></span>
                                    <?php } elseif ( $data['cat_layout'] == 'cat_layout2' ) { ?>
                                    <span class="entry-categories style-2 meta-light-color"><?php echo the_category( ', ' );?></span>
                                    <?php } ?>
                                <?php } ?>
                                <h3 class="entry-title title-size-sm title-light-color mb-1"><a href="javascript:void(0)"><?php echo esc_html( $small_title );?></a></h3>
                                <?php if ( $gamxo_has_entry_meta2 ) { ?>
                                <ul class="entry-meta meta-light-color mb-0">
                                    <?php if ( $data['small_post_date'] == 'yes' ) { ?> 
                                     <li class="post-date"><i class="far fa-calendar-alt"></i><?php echo get_the_date(); ?></li> 
                                    <?php } if ( $data['small_post_author'] == 'yes' ) { ?>
                                    <li class="post-author"><i class="far fa-user"></i><?php esc_html_e( 'by ', 'gamxo' );?><?php the_author_posts_link(); ?></li>
                                    <?php } if ( $data['small_post_comment'] == 'yes' ) { ?>
                                    <li class="post-comment"><i class="far fa-comments"></i><a href="<?php echo get_comments_link( get_the_ID() ); ?>"><?php echo wp_kses( $gamxo_comments_html , 'alltext_allow' );?></a></li>
                                    <?php } if ( ( $data['small_post_length'] == 'yes' ) && function_exists( 'gamxo_reading_time' ) ) { ?>
                                    <li class="post-reading-time meta-item"><i class="far fa-clock"></i><?php echo gamxo_reading_time(); ?></li>
                                    <?php } if ( ( $data['small_post_view'] == 'yes' ) && function_exists( 'gamxo_views' ) ) { ?>
                                    <li><span class="post-views meta-item"><i class="fas fa-signal"></i><?php echo gamxo_views(); ?></span></li>
                                    <?php } ?>
                                </ul>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                   <?php endwhile;?>        
                   <?php endif;?>
                </div>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    </div>
</div>