<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Background;

if ( ! defined( 'ABSPATH' ) ) exit;

class Post_Slider extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Post Slider', 'gamxo-core' );
		$this->rt_base = 'rt-post-slider';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$repeater = new \Elementor\Repeater();
		
		$repeater->add_control(
			'post_not_in', array(
				'type'    => Controls_Manager::NUMBER,
				'label'   => __( 'Post ID', 'gamxo-core' ),
				'default' => '0',
			)
		);
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'gamxo-core' ),
				'options' => array(
					'style1' => esc_html__( 'Post Slider 01', 'gamxo-core' ),
					'style2' => esc_html__( 'Post Slider 02', 'gamxo-core' ),
					'style3' => esc_html__( 'Post Slider 03', 'gamxo-core' ),
					'style4' => esc_html__( 'Post Slider 04', 'gamxo-core' ),
				),
				'default' => 'style1',
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat_layout',
				'label'   => esc_html__( 'Category Layout', 'gamxo-core' ),				
				'options' => array(
					'cat_layout1' 		=> esc_html__( 'Cat Layout 1', 'gamxo-core' ),
					'cat_layout2' 		=> esc_html__( 'Cat Layout 2', 'gamxo-core' ),
				),
				'default' => 'cat_layout1',
			),
			/*end category*/
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'itemlimit',
				'label'   => esc_html__( 'Item Limit', 'gamxo-core' ),
				'range' => array(
	                'px' => array(
	                    'min' => 1,
	                    'max' => 27,
	               	),
		       	),
	            'default' => array(
	                'size' => 3,
	            ),
				'description' => esc_html__( 'Maximum number of Item 27', 'gamxo-core' ),
			),			
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'title_count',
				'label'   => esc_html__( 'Title count', 'gamxo-core' ),
				'default' => 15,
				'description' => esc_html__( 'Maximum number of title', 'gamxo-core' ),
			),
			array(
				'mode' => 'section_end',
			),
			/*query option*/
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_query',
				'label'   => esc_html__( 'Query Settings', 'gamxo-core' ),
			),
			/*Post Order*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_ordering',
				'label'   => esc_html__( 'Post Ordering', 'gamxo-core' ),
				'options' => array(
					'DESC'	=> esc_html__( 'Desecending', 'gamxo-core' ),
					'ASC'	=> esc_html__( 'Ascending', 'gamxo-core' ),
				),
				'default' => 'DESC',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'post_orderby',
				'label'   => esc_html__( 'Post Sorting', 'gamxo-core' ),				
				'options' => array(
					'recent' 		=> esc_html__( 'Recent Post', 'gamxo-core' ),
					'rand' 			=> esc_html__( 'Random Post', 'gamxo-core' ),
					'menu_order' 	=> esc_html__( 'Custom Order', 'gamxo-core' ),
					'title' 		=> esc_html__( 'By Name', 'gamxo-core' ),
				),
				'default' => 'recent',
			),
			/*Start category*/
			array(
				'id'      => 'query_type',
				'label' => esc_html__( 'Query type', 'gamxo-core' ),
            	'type' => Controls_Manager::SELECT,
            	'default' => 'category',
            	'options' => array(
					'category'  => esc_html__( 'Category', 'gamxo-core' ),
                	'posts' => esc_html__( 'Posts', 'gamxo-core' ),
				),
			),
			array(
				'id'      => 'postid',
				'label' => esc_html__( 'Selects posts', 'gamxo-core' ),
	            'type' => Controls_Manager::SELECT2,
	            'options' => $this->get_all_posts('post'),
	            'label_block' => true,
	            'multiple' => true,
            	'condition' => array(
					'query_type' => 'posts',
				),
			),
			array(
				'id'      => 'catid',
				'label' => esc_html__( 'Categories', 'gamxo-core' ),
	            'type' => Controls_Manager::SELECT2,
	            'options' => $this->get_taxonomy_drops('category'),
	            'label_block' => true,
	            'multiple' => true,
            	'condition' => array(
					'query_type' => 'category',
				),
			),
			/*post offset*/
	        array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number_of_post_offset',
				'label'   => __( 'Offset ( No of Posts )', 'gamxo-core' ),
				'default' => '0',
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::REPEATER,
				'id'      => 'posts_not_in',
				'label'   => __( 'Exclude Post by ID', 'gamxo-core' ),
				'fields' => $repeater->get_controls(),
			),
			array(
				'mode' => 'section_end',
			),
			// Option
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_style',
				'label'   => esc_html__( 'Option', 'gamxo-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_author',
				'label'       => esc_html__( 'Show Author', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'yes',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_date',
				'label'       => esc_html__( 'Show Date', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'yes',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_category',
				'label'       => esc_html__( 'Show Categories', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'yes',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_comment',
				'label'       => esc_html__( 'Show Comment', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'no',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_length',
				'label'       => esc_html__( 'Show Lenght', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'no',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_view',
				'label'       => esc_html__( 'Show View', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'no',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_video',
				'label'       => esc_html__( 'Show Video', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'no',
			),
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'post_read',
				'label'       => esc_html__( 'Show Read More', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'no',
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'read_more_text',
				'label'   => esc_html__( 'Button Text', 'gamxo-core' ),
				'default' => esc_html__( 'Read More', 'gamxo-core' ),
				'condition' => array( 'post_read' => array( 'yes' ) ),
			),
			array(
				'type'    => Group_Control_Css_Filter::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'Image Blend', 'gamxo-core' ),	
				'name' => 'blend', 
				'selector' => '{{WRAPPER}} img',		
			),			
			array(
	            'type'    => Controls_Manager::DIMENSIONS,
	            'mode'          => 'responsive',
	            'size_units' => [ 'px', '%', 'em' ],
	            'id'      => 'border_radius',
	            'label'   => __( 'Radius', 'gamxo-core' ),                 
	            'selectors' => array(
	                '{{WRAPPER}} .rt-post-slider-default .rt-item .rt-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                  
	            ),
	            'separator' => 'before',
	        ),
			array(
				'mode' => 'section_end',
			),
			// Title style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_title_style',
	            'label'   => esc_html__( 'Title Typo', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
	        array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Style', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-post-slider-default .rt-item .entry-title',
			),
			array(
				'type'    => Group_Control_Background::get_type(),
				'mode'    => 'group',
				'types'   => array( 'classic', 'gradient' ),
				'name'    => 'title_color',
				'label'   => esc_html__( 'Title Color', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-post-slider-default .rt-item .entry-title a',
			),
			array(
	            'type'    => Controls_Manager::DIMENSIONS,
	            'mode'          => 'responsive',
	            'size_units' => [ 'px', '%', 'em' ],
	            'id'      => 'title_margin',
	            'label'   => __( 'Margin', 'gamxo-core' ),                 
	            'selectors' => array(
	                '{{WRAPPER}} .rt-post-slider-default .rt-item .entry-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
	            ),
	            'separator' => 'before',
	        ),
			array(
				'mode' => 'section_end',
			),
			// Content style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_content_style',
	            'label'   => esc_html__( 'Content Style', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
	        array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'content_display',
				'label'       => esc_html__( 'Content Display', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'no',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'count',
				'label'   => esc_html__( 'Word count', 'gamxo-core' ),
				'default' => 20,
				'condition' => array( 'content_display' => array( 'yes' ) ),
				'description' => esc_html__( 'Maximum number of words', 'gamxo-core' ),
			),
	        array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'content_typo',
				'label'   => esc_html__( 'Content_typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-post-slider-default .rt-item .post_excerpt p',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => esc_html__( 'Content Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-post-slider-default .rt-item .post_excerpt p' => 'color: {{VALUE}}',
				),
			),
			array(
	            'type'    => Controls_Manager::DIMENSIONS,
	            'mode'          => 'responsive',
	            'size_units' => [ 'px', '%', 'em' ],
	            'id'      => 'content_margin',
	            'label'   => __( 'Margin', 'gamxo-core' ),                 
	            'selectors' => array(
	                '{{WRAPPER}} .rt-post-slider-default .rt-item .post_excerpt p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
	            ),
	            'separator' => 'before',
	        ),
			array(
				'mode' => 'section_end',
			),			
			// Meta style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_meta_style',
	            'label'   => esc_html__( 'Meta Style', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
	        array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'meta_typo',
				'label'   => esc_html__( 'Meta Typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-post-slider-default ul.entry-meta li',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_color',
				'label'   => esc_html__( 'Meta Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-post-slider-default ul.entry-meta li' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-post-slider-default ul.entry-meta li a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-post-slider-default .rt-item .rt-cat a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_author_color',
				'label'   => esc_html__( 'Meta Author Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-post-slider-default .rt-item .post-author a' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'meta_icon_color',
				'label'   => esc_html__( 'Meta Icon Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-post-slider-default ul.entry-meta li i' => 'color: {{VALUE}}',
				),
			),
			array(
	            'type'    => Controls_Manager::DIMENSIONS,
	            'mode'          => 'responsive',
	            'size_units' => [ 'px', '%', 'em' ],
	            'id'      => 'meta_margin',
	            'label'   => __( 'Margin', 'gamxo-core' ),                 
	            'selectors' => array(
	                '{{WRAPPER}} .rt-post-slider-default ul.entry-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
	            ),
	            'separator' => 'before',
	        ),
	        array(
				'mode' => 'section_end',
			),
			// Image style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_image_style',
	            'label'   => esc_html__( 'Image', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	            'condition'   => array( 'style' => array( 'style2' ) ),
	        ),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'image_width',
				'mode'          => 'responsive',
				'label'   => esc_html__( 'Width', 'gamxo-core' ),
				'size_units' => array( '%', 'px', 'vw' ),
				'range' => array(
					'%' => array(
						'min' => 1,
						'max' => 100,
					),
					'px' => array(
						'min' => 1,
						'max' => 1000,
					),
					'vw' => array(
						'min' => 1,
						'max' => 100,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .rt-post-slider-default .rt-item .rt-image img' => 'width: {{SIZE}}{{UNIT}};',
				),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'id'      => 'image_height',
				'mode'          => 'responsive',
				'label'   => esc_html__( 'Height', 'gamxo-core' ),
				'size_units' => array( '%', 'px', 'vw' ),
				'range' => array(
					'%' => array(
						'min' => 1,
						'max' => 100,
					),
					'px' => array(
						'min' => 1,
						'max' => 1000,
					),
					'vw' => array(
						'min' => 1,
						'max' => 100,
					),
				),
				'selectors' => array(
					'{{WRAPPER}} .rt-post-slider-default .rt-item .rt-image img' => 'height: {{SIZE}}{{UNIT}};',
				),
			),
	        array(
				'mode' => 'section_end',
			),
			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'gamxo-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'gamxo-core' ),
					'hide'        => esc_html__( 'Off', 'gamxo-core' ),
				),
				'default' => 'wow',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'gamxo-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'gamxo-core' ),
					'bounce' => esc_html__( 'bounce', 'gamxo-core' ),
					'flash' => esc_html__( 'flash', 'gamxo-core' ),
					'pulse' => esc_html__( 'pulse', 'gamxo-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'gamxo-core' ),
					'shakeX' => esc_html__( 'shakeX', 'gamxo-core' ),
					'shakeY' => esc_html__( 'shakeY', 'gamxo-core' ),
					'headShake' => esc_html__( 'headShake', 'gamxo-core' ),
					'swing' => esc_html__( 'swing', 'gamxo-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'gamxo-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'gamxo-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'gamxo-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'gamxo-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'gamxo-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'gamxo-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'gamxo-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'gamxo-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'gamxo-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'gamxo-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'gamxo-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'gamxo-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'gamxo-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'gamxo-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'gamxo-core' ),
				'default' => '0.5',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'gamxo-core' ),
				'default' => '1',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Slider Columns
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider_pervice',
				'label'       => esc_html__( 'PerView Options', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'desktop',
				'label'   => esc_html__( 'Desktops: > 1600px', 'gamxo-core' ),
				'default' => '4',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
					'5' => esc_html__( '5',  'gamxo-core' ),
					'6' => esc_html__( '6',  'gamxo-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'md_desktop',
				'label'   => esc_html__( 'Desktops: > 1200px', 'gamxo-core' ),
				'default' => '3',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'sm_desktop',
				'label'   => esc_html__( 'Desktops: > 992px', 'gamxo-core' ),
				'default' => '2',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'tablet',
				'label'   => esc_html__( 'Tablets: > 768px', 'gamxo-core' ),
				'default' => '2',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'mobile',
				'label'   => esc_html__( 'Phones: > 576px', 'gamxo-core' ),
				'default' => '1',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
				),
			),
			array(
				'mode' => 'section_end',
			),

			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'gamxo-core' ),
			),			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'gamxo-core' ),
			),			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'display_arrow',
				'label'       => esc_html__( 'Navigation Arrow', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Navigation Arrow. Default: On', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'nav_style',
				'label'   => esc_html__( 'Nav Style', 'gamxo-core' ),				
				'options' => array(
					'rt-swiper-nav-1' 		=> esc_html__( 'Nav Style 1', 'gamxo-core' ),
					'rt-swiper-nav-2' 		=> esc_html__( 'Nav Style 2', 'gamxo-core' ),
					'rt-swiper-nav-3' 		=> esc_html__( 'Nav Style 3', 'gamxo-core' ),
					'rt-swiper-nav-4' 		=> esc_html__( 'Nav Style 4', 'gamxo-core' ),
					'rt-swiper-nav-5' 		=> esc_html__( 'Nav Style 5', 'gamxo-core' ),
				),
				'default' => 'rt-swiper-nav-1',
				'condition'   => array( 'display_arrow' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'display_buttet',
				'label'       => esc_html__( 'Pagination', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Navigation Arrow. Default: Off', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'mode' 			=> 'responsive',
				'id'      => 'slides_per_group',
				'label'   => esc_html__( 'slides Per Group', 'gamxo-core' ),
				'default' => array(
					'size' => 1,
				),
				'description' => esc_html__( 'slides Per Group. Default: 1', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'centered_slides',
				'label'       => esc_html__( 'Centered Slides', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Centered Slides. Default: Off', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'mode' 			=> 'responsive',
				'id'      => 'slides_space',
				'label'   => esc_html__( 'Slides Space', 'gamxo-core' ),
				'size_units' => array( 'px', '%' ),
				'default' => array(
					'unit' => 'px',
					'size' => 24,
				),
				'description' => esc_html__( 'Slides Space. Default: 24', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_delay',
				'label'   => esc_html__( 'Autoplay Slide Delay', 'gamxo-core' ),
				'default' => 5000,
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'gamxo-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => esc_html__( 'Autoplay Slide Speed', 'gamxo-core' ),
				'default' => 1000,
				'description' => esc_html__( 'Set any value for example .8 seconds to play it in every 2 seconds. Default: .8 Seconds', 'gamxo-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'gamxo-core' ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$swiper_data = array(
			'slidesPerView' 	=>2,
			'loop'				=>$data['slider_loop']=='yes' ? true:false,
			'spaceBetween'		=>$data['slides_space']['size'],
			'slidesPerGroup'	=>$data['slides_per_group']['size'],
			'centeredSlides'	=>$data['centered_slides']=='yes' ? true:false ,
			'slideToClickedSlide' =>true,
			'autoplay'          => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplaydelay'     => $data['slider_autoplay_delay'],
			'speed'      =>$data['slider_autoplay_speed'],
			'breakpoints' =>array(
				'0'    =>array('slidesPerView' =>1),
				'576'    =>array('slidesPerView' =>$data['mobile']),
				'768'    =>array('slidesPerView' =>$data['tablet']),
				'992'    =>array('slidesPerView' =>$data['sm_desktop']),
				'1200'    =>array('slidesPerView' =>$data['md_desktop']),				
				'1600'    =>array('slidesPerView' =>$data['desktop'])
			),
		);
		
		switch ( $data['style'] ) {
			case 'style4':
			$template = 'post-slider-4';
			break;
			case 'style3':
			$template = 'post-slider-3';
			break;
			case 'style2':
			$template = 'post-slider-2';
			break;
			default:
			$template = 'post-slider-1';
			break;
		}

		$data['swiper_data'] = json_encode( $swiper_data );   
		
		return $this->rt_template( $template, $data );
	}
}