<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Button extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Button', 'gamxo-core' );
		$this->rt_base = 'rt-button';
		parent::__construct( $data, $args );
	}
	
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'gamxo-core' ),
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'	  => 'responsive',
				'label'   => esc_html__( 'Alignment', 'gamxo-core' ),
				'options' => array(
					'left' => array(
						'title' => __( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => __( 'Justified', 'elementor' ),
						'icon' => 'eicon-text-align-justify',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				),
			),
			array(
				'type'    	  => Controls_Manager::TEXT,
				'id'      	  => 'buttontext',
				'label'   	  => esc_html__( 'Button Text', 'gamxo-core' ),
				'default' 	  => esc_html__( 'Contact Us', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'buttonurl',
				'label'   => esc_html__( 'Button URL', 'gamxo-core' ),
				'placeholder' => 'https://your-link.com',
			),
			array(
				'mode' => 'section_end',
			),

			// Button style 1
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button_style1',
				'label'   => esc_html__( 'Button Style', 'gamxo-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'button_typo1',
				'label'   => esc_html__( 'Button Typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-button a',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_text_color',
				'label'   => esc_html__( 'Button Text Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-button a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-button a i' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_text_hover_color',
				'label'   => esc_html__( 'Button Text Hover Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-button a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-button a:hover i' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'button_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Button Margin', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'button_padding',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Button Padding', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-button a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'button_radius',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Button Radius', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-button a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),	
			array(
				'mode' => 'section_end',
			),
			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'gamxo-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'gamxo-core' ),
					'hide'        => esc_html__( 'Off', 'gamxo-core' ),
				),
				'default' => 'hide',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'gamxo-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'gamxo-core' ),
					'bounce' => esc_html__( 'bounce', 'gamxo-core' ),
					'flash' => esc_html__( 'flash', 'gamxo-core' ),
					'pulse' => esc_html__( 'pulse', 'gamxo-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'gamxo-core' ),
					'shakeX' => esc_html__( 'shakeX', 'gamxo-core' ),
					'shakeY' => esc_html__( 'shakeY', 'gamxo-core' ),
					'headShake' => esc_html__( 'headShake', 'gamxo-core' ),
					'swing' => esc_html__( 'swing', 'gamxo-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'gamxo-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'gamxo-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'gamxo-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'gamxo-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'gamxo-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'gamxo-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'gamxo-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'gamxo-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'gamxo-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'gamxo-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'gamxo-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'gamxo-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'gamxo-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'gamxo-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'digeco-core' ),
				'default' => '1',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'digeco-core' ),
				'default' => '1',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),	
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'rt-button';

		return $this->rt_template( $template, $data );
	}
}