<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Category extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Category', 'gamxo-core' );
		$this->rt_base = 'rt-category';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'gamxo-core' ),
				'6'  => esc_html__( '2 Col', 'gamxo-core' ),
				'4'  => esc_html__( '3 Col', 'gamxo-core' ),
				'3'  => esc_html__( '4 Col', 'gamxo-core' ),
				'2'  => esc_html__( '6 Col', 'gamxo-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Category Style', 'gamxo-core' ),
				'options' => array(
					'style1' => esc_html__( 'Grid Layout 01' , 'gamxo-core' ),
					'style4' => esc_html__( 'Grid Layout 02' , 'gamxo-core' ),
					'style5' => esc_html__( 'Grid Layout 03' , 'gamxo-core' ),
					'style2' => esc_html__( 'List Layout' , 'gamxo-core' ),
					'style3' => esc_html__( 'Slider Layout', 'gamxo-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'item_space',
				'label'   => esc_html__( 'Item Space', 'gamxo-core' ),
				'options' => array(
					'g-0' => esc_html__( 'Gutters 0', 'gamxo-core' ),
					'g-1' => esc_html__( 'Gutters 1', 'gamxo-core' ),
					'g-2' => esc_html__( 'Gutters 2', 'gamxo-core' ),
					'g-3' => esc_html__( 'Gutters 3', 'gamxo-core' ),
					'g-4' => esc_html__( 'Gutters 4', 'gamxo-core' ),
					'g-5' => esc_html__( 'Gutters 5', 'gamxo-core' ),
				),
				'default' => 'g-4',
				'condition'   => array( 'style' => array( 'style1','style2','style4','style5' ) ),
			),
			/*Start category*/
			array(
				'id'      => 'catid',
				'label' => esc_html__( 'Categories', 'gamxo-core' ),
	            'type' => Controls_Manager::SELECT2,
	            'options' => $this->get_taxonomy_drops('category'),
	            'label_block' => true,
	            'multiple' => true,
			),
			/*end category*/
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'gamxo-core' ),
				'default' => esc_html__( 'Today Best Trending Topics', 'gamxo-core' ),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Style', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .section-title .related-title',
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .section-title .related-title' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'mode' => 'section_end',
			),

			/*Animation section*/
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_cat_style',
	            'label'   => esc_html__( 'Category', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
	        array(
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'cat_typo',
				'label'   => esc_html__( 'Category Typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-category .rt-item .rt-cat-name',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'cat_color',
				'label'   => esc_html__( 'Category Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-category .rt-item .rt-cat-name a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-category-style2 .rt-item .rt-cat-name' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'cat_hov_color',
				'label'   => esc_html__( 'Category Hover Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-category .rt-item .rt-cat-name a:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-category-style2 .rt-item a:hover .rt-cat-name' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'cat_count',
				'label'       => esc_html__( 'Count Display', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Count. Default: true', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'mode' 			=> 'responsive',
				'id'      => 'item_bottom',
				'label'   => esc_html__( 'Item Padding', 'gamxo-core' ),
				'size_units' => array( 'px', '%' ),
				'default' => array(
					'unit' => 'px',
					'size' => '',
				),
				'selectors' => array(
					'{{WRAPPER}} .rt-category-style3 .rt-content' => 'bottom: {{SIZE}}{{UNIT}};',
				),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
	        array(
				'mode' => 'section_end',
			),

			// Responsive Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'gamxo-core' ),
				'condition'   => array( 'style' => array( 'style1','style2','style4','style5' ) ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xl',
				'label'   => esc_html__( 'Desktops: > 1199px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 991px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Tablets: > 767px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Phones: > 576px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col',
				'label'   => esc_html__( 'Phones: < 576px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),
			// Animation
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	            'condition'   => array( 'style' => array( 'style2' ) ),
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'gamxo-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'gamxo-core' ),
					'hide'        => esc_html__( 'Off', 'gamxo-core' ),
				),
				'default' => 'wow',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'gamxo-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'gamxo-core' ),
					'bounce' => esc_html__( 'bounce', 'gamxo-core' ),
					'flash' => esc_html__( 'flash', 'gamxo-core' ),
					'pulse' => esc_html__( 'pulse', 'gamxo-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'gamxo-core' ),
					'shakeX' => esc_html__( 'shakeX', 'gamxo-core' ),
					'shakeY' => esc_html__( 'shakeY', 'gamxo-core' ),
					'headShake' => esc_html__( 'headShake', 'gamxo-core' ),
					'swing' => esc_html__( 'swing', 'gamxo-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'gamxo-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'gamxo-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'gamxo-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'gamxo-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'gamxo-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'gamxo-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'gamxo-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'gamxo-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'gamxo-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'gamxo-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'gamxo-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'gamxo-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'gamxo-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'gamxo-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'delay',
				'label'   => esc_html__( 'Delay', 'digeco-core' ),
				'default' => '0.5',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'digeco-core' ),
				'default' => '1',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'mode' => 'section_end',
			),
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'gamxo-core' ),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'display_arrow',
				'label'       => esc_html__( 'Navigation Arrow', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Navigation Arrow. Default: On', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'mode' 			=> 'responsive',
				'id'      => 'slides_per_group',
				'label'   => esc_html__( 'slides Per Group', 'gamxo-core' ),
				'size_units' => array( 'px', '%' ),
				'default' => array(
					'unit' => 'px',
					'size' => 1,
				),
				'description' => esc_html__( 'slides Per Group. Default: 1', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'centered_slides',
				'label'       => esc_html__( 'Centered Slides', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Centered Slides. Default: Off', 'gamxo-core' ),
				'condition'   => array( 'style' => array( 'style1', 'style2' ) ),
			),
			array(
				'type'        => Controls_Manager::NUMBER,
				'id'          => 'slides_space',
				'label'       => esc_html__( 'Slides Space', 'consalty-core' ),
				'default'     => 10,
				'description' => esc_html__( 'Slides Space. Default: 10', 'consalty-core' ),
			),		
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_delay',
				'label'   => esc_html__( 'Autoplay Slide Delay', 'gamxo-core' ),
				'default' => 5000,
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'gamxo-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => esc_html__( 'Autoplay Slide Speed', 'gamxo-core' ),
				'default' => 1000,
				'description' => esc_html__( 'Set any value for example .8 seconds to play it in every 2 seconds. Default: .8 Seconds', 'gamxo-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'gamxo-core' ),
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Slider Columns
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider_pervice',
				'label'       => esc_html__( 'PerView Options', 'consalty-core' ),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'desktop',
				'label'   => esc_html__( 'Desktops: > 1600px', 'consalty-core' ),
				'default' => '4',
				'options' => array(
					'1' => esc_html__( '1', 'consalty-core' ),
					'2' => esc_html__( '2', 'consalty-core' ),
					'3' => esc_html__( '3',  'consalty-core' ),
					'4' => esc_html__( '4',  'consalty-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'md_desktop',
				'label'   => esc_html__( 'Desktops: > 1200px', 'consalty-core' ),
				'default' => '3',
				'options' => array(
					'1' => esc_html__( '1', 'consalty-core' ),
					'2' => esc_html__( '2', 'consalty-core' ),
					'3' => esc_html__( '3',  'consalty-core' ),
					'4' => esc_html__( '4',  'consalty-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'sm_desktop',
				'label'   => esc_html__( 'Desktops: > 992px', 'consalty-core' ),
				'default' => '2',
				'options' => array(
					'1' => esc_html__( '1', 'consalty-core' ),
					'2' => esc_html__( '2', 'consalty-core' ),
					'3' => esc_html__( '3',  'consalty-core' ),
					'4' => esc_html__( '4',  'consalty-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'tablet',
				'label'   => esc_html__( 'Tablets: > 768px', 'consalty-core' ),
				'default' => '2',
				'options' => array(
					'1' => esc_html__( '1', 'consalty-core' ),
					'2' => esc_html__( '2', 'consalty-core' ),
					'3' => esc_html__( '3',  'consalty-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'mobile',
				'label'   => esc_html__( 'Phones: > 576px', 'consalty-core' ),
				'default' => '1',
				'options' => array(
					'1' => esc_html__( '1', 'consalty-core' ),
					'2' => esc_html__( '2', 'consalty-core' ),
					'3' => esc_html__( '3',  'consalty-core' ),
					'4' => esc_html__( '4',  'consalty-core' ),
				),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		$swiper_data = array(
			'slidesPerView' 	=>2,
			'centeredSlides'	=>$data['centered_slides']=='yes' ? true:false ,
			'loop'				=>$data['slider_loop']=='yes' ? true:false,
			'spaceBetween'		=>$data['slides_space'],
			'slidesPerGroup'	=>$data['slides_per_group']['size'],
			'centeredSlides'	=>$data['centered_slides']=='yes' ? true:false ,
			'slideToClickedSlide' =>true,
			'autoplay'          => $data['slider_autoplay'] == 'yes' ? true : false,
			'autoplaydelay'     => $data['slider_autoplay_delay'],
			'speed'      =>$data['slider_autoplay_speed'],
			'breakpoints' =>array(
				'0'    =>array('slidesPerView' =>1),
				'576'    =>array('slidesPerView' =>$data['mobile']),
				'768'    =>array('slidesPerView' =>$data['tablet']),
				'992'    =>array('slidesPerView' =>$data['sm_desktop']),
				'1200'    =>array('slidesPerView' =>$data['md_desktop']),				
				'1600'    =>array('slidesPerView' =>$data['desktop'])
			),
		);

		switch ( $data['style'] ) {
			case 'style5':
			$template = 'rt-category-5';
			break;
			case 'style4':
			$template = 'rt-category-4';
			break;
			case 'style3':
			$data['swiper_data'] = json_encode( $swiper_data );
			$template = 'rt-category-3';
			break;
			case 'style2':
			$template = 'rt-category-2';
			break;
			default:			
			$template = 'rt-category-1';
			break;
		}
		
		return $this->rt_template( $template, $data );
	}
}