<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Css_Filter;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Team extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Team', 'gamxo-core' );
		$this->rt_base = 'rt-team';
		$this->rt_translate = array(
			'cols'  => array(
				'12' => esc_html__( '1 Col', 'gamxo-core' ),
				'6'  => esc_html__( '2 Col', 'gamxo-core' ),
				'4'  => esc_html__( '3 Col', 'gamxo-core' ),
				'3'  => esc_html__( '4 Col', 'gamxo-core' ),
				'2'  => esc_html__( '6 Col', 'gamxo-core' ),
			),
		);
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$terms = get_terms( array( 'taxonomy' => 'gamxo_team_category', 'fields' => 'id=>name' ) );
		$category_dropdown = array( '0' => esc_html__( 'All Categories', 'gamxo-core' ) );

		foreach ( $terms as $id => $name ) {
			$category_dropdown[$id] = $name;
		}

		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Style', 'gamxo-core' ),
				'options' => array(
					'style1' => esc_html__( 'Team Grid 1', 'gamxo-core' ),
					'style2' => esc_html__( 'Team Grid 2', 'gamxo-core' ),
					'style3' => esc_html__( 'Team Grid 3', 'gamxo-core' ),
					'style4' => esc_html__( 'Team Slider 1', 'gamxo-core' ),
					'style5' => esc_html__( 'Team Slider 2', 'gamxo-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'number',
				'label'   => esc_html__( 'Total number of items', 'gamxo-core' ),
				'default' => 6,
				'description' => esc_html__( 'Write -1 to show all', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'item_space',
				'label'   => esc_html__( 'Item Space', 'gamxo-core' ),
				'options' => array(
					'g-0' => esc_html__( 'Gutters 0', 'gamxo-core' ),
					'g-1' => esc_html__( 'Gutters 1', 'gamxo-core' ),
					'g-2' => esc_html__( 'Gutters 2', 'gamxo-core' ),
					'g-3' => esc_html__( 'Gutters 3', 'gamxo-core' ),
					'g-4' => esc_html__( 'Gutters 4', 'gamxo-core' ),
					'g-5' => esc_html__( 'Gutters 5', 'gamxo-core' ),
				),
				'default' => 'g-4',
				'condition'   => array( 'style' => array( 'style1', 'style2', 'style3' ) ),
			),			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'cat',
				'label'   => esc_html__( 'Categories', 'gamxo-core' ),
				'options' => $category_dropdown,
				'default' => '0',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'orderby',
				'label'   => esc_html__( 'Order By', 'gamxo-core' ),
				'options' => array(
					'date'        => esc_html__( 'Date (Recents comes first)', 'gamxo-core' ),
					'title'       => esc_html__( 'Title', 'gamxo-core' ),
					'menu_order'  => esc_html__( 'Custom Order (Available via Order field inside Page Attributes box)', 'gamxo-core' ),
				),
				'default' => 'date',
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'content_display',
				'label'       => esc_html__( 'Content Display', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'no',
				'description' => esc_html__( 'Show or Hide Content. Default: off', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'contype',
				'label'   => esc_html__( 'Content Type', 'gamxo-core' ),
				'options' => array(
					'content' => esc_html__( 'Conents', 'gamxo-core' ),
					'excerpt' => esc_html__( 'Excerpts', 'gamxo-core' ),
				),
				'default'     => 'content',
				'description' => esc_html__( 'Display contents from Editor or Excerpt field', 'gamxo-core' ),
				'condition'   => array( 'content_display' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'count',
				'label'   => esc_html__( 'Word count', 'gamxo-core' ),
				'default' => 12,
				'description' => esc_html__( 'Maximum number of words', 'gamxo-core' ),
				'condition'   => array( 'content_display' => 'yes' ),
			),			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'designation_display',
				'label'       => esc_html__( 'Designation Display', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Designation. Default: On', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'social_display',
				'label'       => esc_html__( 'Social Media Display', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide Social Medias. Default: On', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'more_items_display',
				'label'       => esc_html__( 'Show More Items', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Show or Hide More Items. Default: On', 'gamxo-core' ),				
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'more_button',
				'label'   => esc_html__( 'More Button', 'gamxo-core' ),
				'options' => array(
					'show'        => esc_html__( 'Show Read More', 'gamxo-core' ),
					'hide'        => esc_html__( 'Show Pagination', 'gamxo-core' ),
				),
				'default' => 'show',
				'condition'   => array( 'more_items_display' => array( 'yes' ), 'style' => array( 'style1', 'style2', 'style3' ) ),
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_text',
				'label'   => esc_html__( 'Button Text', 'gamxo-core' ),
				'condition'   => array( 'more_button' => array( 'show' ) ),
				'default' => esc_html__( 'More Teams', 'gamxo-core' ),
				'condition'   => array( 'more_items_display' => array( 'yes' ), 'more_button' => array( 'show' ), 'style' => array( 'style1', 'style2', 'style3' ) ),
			),
			array (
				'type'    => Controls_Manager::TEXT,
				'id'      => 'see_button_link',
				'label'   => esc_html__( 'Button Link', 'gamxo-core' ),
				'condition'   => array( 'more_items_display' => array( 'yes' ), 'more_button' => array( 'show' ), 'style' => array( 'style1', 'style2', 'style3' ) ),
			),
			array(
				'mode' => 'section_end',
			),
			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'gamxo-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'gamxo-core' ),
					'hide'        => esc_html__( 'Off', 'gamxo-core' ),
				),
				'default' => 'wow',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'gamxo-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'gamxo-core' ),
					'bounce' => esc_html__( 'bounce', 'gamxo-core' ),
					'flash' => esc_html__( 'flash', 'gamxo-core' ),
					'pulse' => esc_html__( 'pulse', 'gamxo-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'gamxo-core' ),
					'shakeX' => esc_html__( 'shakeX', 'gamxo-core' ),
					'shakeY' => esc_html__( 'shakeY', 'gamxo-core' ),
					'headShake' => esc_html__( 'headShake', 'gamxo-core' ),
					'swing' => esc_html__( 'swing', 'gamxo-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'gamxo-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'gamxo-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'gamxo-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'gamxo-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'gamxo-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'gamxo-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'gamxo-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'gamxo-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'gamxo-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'gamxo-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'gamxo-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'gamxo-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'gamxo-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'gamxo-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'autoplaydelay',
				'label'   => esc_html__( 'Delay', 'gamxo-core' ),
				'default' => '2000',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'duration',
				'label'   => esc_html__( 'Duration', 'gamxo-core' ),
				'default' => '1',
				'condition'   => array( 'animation' => array( 'wow' ) ),
			),
			array(
				'type'    => Group_Control_Css_Filter::get_type(),
				'mode'    => 'group',				
				'label'   => esc_html__( 'Image Blend', 'gamxo-core' ),	
				'name' => 'blend', 
				'selector' => '{{WRAPPER}} .team-item .team-thums img',		
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Grid Columns
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_responsive',
				'label'   => esc_html__( 'Number of Responsive Columns', 'gamxo-core' ),
				'condition'   => array( 'style' => array( 'style1', 'style2', 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_lg',
				'label'   => esc_html__( 'Desktops: > 1199px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '3',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_md',
				'label'   => esc_html__( 'Desktops: > 991px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '4',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_sm',
				'label'   => esc_html__( 'Tablets: > 767px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '6',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_xs',
				'label'   => esc_html__( 'Phones: < 768px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'col_mobile',
				'label'   => esc_html__( 'Small Phones: < 480px', 'gamxo-core' ),
				'options' => $this->rt_translate['cols'],
				'default' => '12',
			),
			array(
				'mode' => 'section_end',
			),

			// Responsive Slider Columns
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider_pervice',
				'label'       => esc_html__( 'PerView Options', 'gamxo-core' ),
				'condition'   => array( 'style' => array( 'style4', 'style5' ) ),
			),
			
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'desktop',
				'label'   => esc_html__( 'Desktops: > 1600px', 'gamxo-core' ),
				'default' => '4',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
				),
			),

			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'md_desktop',
				'label'   => esc_html__( 'Desktops: > 1200px', 'gamxo-core' ),
				'default' => '3',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'sm_desktop',
				'label'   => esc_html__( 'Desktops: > 992px', 'gamxo-core' ),
				'default' => '2',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'tablet',
				'label'   => esc_html__( 'Tablets: > 768px', 'gamxo-core' ),
				'default' => '2',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
				),
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'mobile',
				'label'   => esc_html__( 'Phones: > 576px', 'gamxo-core' ),
				'default' => '1',
				'options' => array(
					'1' => esc_html__( '1', 'gamxo-core' ),
					'2' => esc_html__( '2', 'gamxo-core' ),
					'3' => esc_html__( '3',  'gamxo-core' ),
					'4' => esc_html__( '4',  'gamxo-core' ),
				),
			),
			array(
				'mode' => 'section_end',
			),
			
			// Slider options
			array(
				'mode'        => 'section_start',
				'id'          => 'sec_slider',
				'label'       => esc_html__( 'Slider Options', 'gamxo-core' ),
				'condition'   => array( 'style' => array( 'style4', 'style5' ) ),
			),			
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_autoplay',
				'label'       => esc_html__( 'Autoplay', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Enable or disable autoplay. Default: On', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'display_arrow',
				'label'       => esc_html__( 'Navigation Arrow', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Navigation Arrow. Default: On', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'display_buttet',
				'label'       => esc_html__( 'Pagination', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Pagination Arrow. Default: On', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::SLIDER,
				'mode' 			=> 'responsive',
				'id'      => 'slides_per_group',
				'label'   => esc_html__( 'slides Per Group', 'gamxo-core' ),
				'default' => array(
					'size' => 1,
				),
				'description' => esc_html__( 'slides Per Group. Default: 1', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'centered_slides',
				'label'       => esc_html__( 'Centered Slides', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Centered Slides. Default: On', 'gamxo-core' ),
				
			),
			array(
				'type'        => Controls_Manager::NUMBER,
				'id'          => 'slides_space',
				'label'       => esc_html__( 'Slides Space', 'gamxo-core' ),
				'default'     => 10,
				'description' => esc_html__( 'Slides Space. Default: 10', 'gamxo-core' ),
			),		
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_delay',
				'label'   => esc_html__( 'Autoplay Slide Delay', 'gamxo-core' ),
				'default' => 2000,
				'description' => esc_html__( 'Set any value for example 5 seconds to play it in every 5 seconds. Default: 5 Seconds', 'gamxo-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'    => Controls_Manager::NUMBER,
				'id'      => 'slider_autoplay_speed',
				'label'   => esc_html__( 'Autoplay Slide Speed', 'gamxo-core' ),
				'default' => 1000,
				'description' => esc_html__( 'Set any value for example .8 seconds to play it in every 2 seconds. Default: .8 Seconds', 'gamxo-core' ),
				'condition'   => array( 'slider_autoplay' => 'yes' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'slider_loop',
				'label'       => esc_html__( 'Loop', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => 'yes',
				'description' => esc_html__( 'Loop to first item. Default: On', 'gamxo-core' ),
			),			
			array(
				'mode' => 'section_end',
			),

		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();
		if($data['slider_autoplay']=='yes'){
			$data['slider_autoplay']=true;
		}
		else{
			$data['slider_autoplay']=false;
		}

		$swiper_data = array(
			'slidesPerView' 	=>2,
			'centeredSlides'	=>$data['centered_slides']=='yes' ? true:false ,
			'loop'				=>$data['slider_loop']=='yes' ? true:false,
			'spaceBetween'		=>$data['slides_space'],
			'slidesPerGroup'	=>$data['slides_per_group']['size'],
			'slideToClickedSlide' =>true,
			'autoplaydelay'     => $data['slider_autoplay_delay'],
			'speed'      =>$data['slider_autoplay_speed'],
			'breakpoints' =>array(
				'0'    =>array('slidesPerView' =>1),
				'576'    =>array('slidesPerView' =>$data['mobile']),
				'768'    =>array('slidesPerView' =>$data['tablet']),
				'992'    =>array('slidesPerView' =>$data['sm_desktop']),
				'1200'    =>array('slidesPerView' =>$data['md_desktop']),				
				'1600'    =>array('slidesPerView' =>$data['desktop'])
			),
			'auto'   =>$data['slider_autoplay']
		);

		
		
		
		
		switch ( $data['style'] ) {
			case 'style5':
			$template = 'team-slider-2';
			break;
			case 'style4':
			$template = 'team-slider-1';
			break;
			case 'style3':
			$template = 'team-grid-3';
			break;
			case 'style2':
			$template = 'team-grid-2';
			break;
			default:
			$template = 'team-grid-1';
			break;
		}
		
		$data['swiper_data'] = json_encode( $swiper_data );   

		return $this->rt_template( $template, $data );
	}
}