<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;

use Elementor\Controls_Manager;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Ticker extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT News Ticker', 'gamxo-core' );
		$this->rt_base = 'rt-ticker';
		parent::__construct( $data, $args );
	}
	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'gamxo-core' ),
			),
			array(
				'type'    	  => Controls_Manager::TEXT,
				'id'      	  => 'ticker_title',
				'label'   	  => esc_html__( 'Ticker Title', 'gamxo-core' ),
				'default' 	  => esc_html__( 'TRENDING', 'gamxo-core' ),
			),
			array(
				'type'    	  => Controls_Manager::NUMBER,
				'id'      	  => 'ticker_item',
				'label'   	  => esc_html__( 'Number of Ticker', 'gamxo-core' ),
				'default' 	  => 5,
			),
			array(
				'type'    	  => Controls_Manager::NUMBER,
				'id'      	  => 'ticker_delay',
				'label'   	  => esc_html__( 'Ticker Delay', 'gamxo-core' ),
				'default' 	  => 3000,
			),
			array(
				'type'    	  => Controls_Manager::NUMBER,
				'id'      	  => 'ticker_speed',
				'label'   	  => esc_html__( 'Ticker Speed', 'gamxo-core' ),
				'default' 	  => 0.10,
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'display_type',
				'label'   => esc_html__( 'Display Type', 'gamxo-core' ),
				'options' => array(
					'fade' => esc_html__( 'Fade', 'gamxo-core' ),
					'reveal' => esc_html__( 'Reveal', 'gamxo-core' ),
				),
				'default' => 'fade',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'ticker_color',
				'label'   => esc_html__( 'Text Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-news-ticker .ticker-content a' => 'color: {{VALUE}}!important' ,
				),
				'separator' => 'before',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'ticker_hover_color',
				'label'   => esc_html__( 'Text Hover Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-news-ticker .ticker-content a:hover' => 'color: {{VALUE}}!important',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'ticker_bg_color',
				'label'   => esc_html__( 'Background Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-news-ticker .ticker-wrapper .ticker-swipe' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-ticker .ticker-wrapper .ticker-content' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-ticker .ticker-wrapper .ticker' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rt-news-ticker .ticker-wrapper .ticker-swipe span' => 'background-color: {{VALUE}}',
				),
			),
			
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		$template = 'rt-ticker';

		return $this->rt_template( $template, $data );
	}
}