<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit;

class RT_Title extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Section Title', 'gamxo-core' );
		$this->rt_base = 'rt-title';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'News Title', 'gamxo-core' ),
			),
			/*box title*/
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'style',
				'label'   => esc_html__( 'Title Style', 'gamxo-core' ),
				'options' => array(
					'style1' => esc_html__( 'Title Style 1' , 'gamxo-core' ),
					'style2' => esc_html__( 'Title Style 2', 'gamxo-core' ),
					'style3' => esc_html__( 'Title Style 3', 'gamxo-core' ),
				),
				'default' => 'style1',
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Alignment', 'gamxo-core' ),
				'options' => array(
					'margin-right: auto; text-align: left' => array(
						'title' => __( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					),
					'margin-left: auto; margin-right: auto; text-align: center' => array(
						'title' => __( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					),
					'margin-left: auto; text-align: right' => array(
						'title' => __( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-section-title .entry-sub-title' => '{{VALUE}};',
					'{{WRAPPER}} .rt-section-title .entry-title' => '{{VALUE}};',
					'{{WRAPPER}} .rt-section-title .entry-text' => '{{VALUE}};',
				),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'sub_title',
				'label'   => esc_html__( 'Sub Title', 'gamxo-core' ),
				'default' => 'Working People',
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'gamxo-core' ),
				'default' => 'Welcome To Gamxo',
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'text',
				'label'   => esc_html__( 'Text', 'gamxo-core' ),
				'default' => 'ec nascetur mus vicideolor rhoncus augue quisque parturientet imperdet sit nisi 
tellus veni faucibus orcimperdietenatis.',
				'condition'   => array( 'style' => array( 'style3' ) ),
			),		
			array (
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'button_display',
				'label'       => esc_html__( 'Button Display', 'gamxo-core' ),
				'label_on'    => esc_html__( 'Show', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Hide', 'gamxo-core' ),
				'default'     => 'no',
				'condition'   => array( 'style' => array( 'style1' ) ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'link_text',
				'label'   => esc_html__( 'Link Text', 'gamxo-core' ),
				'default' => 'See More',
				'condition' => array( 'button_display' => array( 'yes' ) ),
			),		
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'link_url',
				'label'   => esc_html__( 'Link URL', 'gamxo-core' ),
				'placeholder' => 'https://your-link.com',
				'condition' => array( 'button_display' => array( 'yes' ) ),
			),	
			array(
				'mode' => 'section_end',
			),

			/*title section*/
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_title_style',
	            'label'   => esc_html__( 'Title', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Style', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-section-title .entry-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-section-title .entry-title' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-section-title .section-link-url' => 'color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_bg_color',
				'label'   => esc_html__( 'Title Background Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-section-title.style1' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rt-section-title.style1:after' => 'border-top: 10px solid {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style1' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_shape_color',
				'label'   => esc_html__( 'Title Shape Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-section-title.style2:after' => 'background-color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style2' ) ),
			),
			array(
	            'type'    => Controls_Manager::DIMENSIONS,
	            'mode'          => 'responsive',
	            'size_units' => [ 'px', '%', 'em' ],
	            'id'      => 'title_margin',
	            'label'   => __( 'Margin', 'gamxo-core' ),                 
	            'selectors' => array(
	                '{{WRAPPER}} .rt-section-title .entry-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',                    
	            ),
	            'separator' => 'before',
	        ),

	        array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'sub_title_typo',
				'label'   => esc_html__( 'Sub Title Style', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-section-title .entry-sub-title',
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sub_title_color',
				'label'   => esc_html__( 'Sub Title Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-section-title .entry-sub-title' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),

			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'text_typo',
				'label'   => esc_html__( 'Text Style', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-section-title .entry-text',
				'condition'   => array( 'style' => array( 'style3' ) ),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'text_color',
				'label'   => esc_html__( 'Text Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-section-title .entry-text' => 'color: {{VALUE}}',
				),
				'condition'   => array( 'style' => array( 'style3' ) ),
			),

	        array(
				'mode' => 'section_end',
			),
			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'gamxo-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'gamxo-core' ),
					'hide'        => esc_html__( 'Off', 'gamxo-core' ),
				),
				'default' => 'hide',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'gamxo-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'gamxo-core' ),
					'bounce' => esc_html__( 'bounce', 'gamxo-core' ),
					'flash' => esc_html__( 'flash', 'gamxo-core' ),
					'pulse' => esc_html__( 'pulse', 'gamxo-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'gamxo-core' ),
					'shakeX' => esc_html__( 'shakeX', 'gamxo-core' ),
					'shakeY' => esc_html__( 'shakeY', 'gamxo-core' ),
					'headShake' => esc_html__( 'headShake', 'gamxo-core' ),
					'swing' => esc_html__( 'swing', 'gamxo-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'gamxo-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'gamxo-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'gamxo-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'gamxo-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'gamxo-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'gamxo-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'gamxo-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'gamxo-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'gamxo-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'gamxo-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'gamxo-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'gamxo-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'gamxo-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'gamxo-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),			
			array(
				'mode' => 'section_end',
			),

		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();

		switch ( $data['style'] ) {
			case 'style3':
			$template = 'title-3';
			break;
			case 'style2':
			$template = 'title-2';
			break;
			default:
			$template = 'title-1';
			break;
		}

		return $this->rt_template( $template, $data );
	}
}