<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

if ( ! defined( 'ABSPATH' ) ) exit;

class Text_With_Button extends Custom_Widget_Base {

	public function __construct( $data = [], $args = null ){
		$this->rt_name = esc_html__( 'RT Title Text With Button', 'gamxo-core' );
		$this->rt_base = 'rt-text-with-button';
		parent::__construct( $data, $args );
	}

	public function rt_fields(){
		$fields = array(
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_general',
				'label'   => esc_html__( 'General', 'gamxo-core' ),
			),
			array(
				'type' => Controls_Manager::CHOOSE,
				'id'      => 'content_align',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Alignment', 'gamxo-core' ),
				'options' => array(
					'left' => array(
						'title' => __( 'Left', 'elementor' ),
						'icon' => 'eicon-text-align-left',
					),
					'center' => array(
						'title' => __( 'Center', 'elementor' ),
						'icon' => 'eicon-text-align-center',
					),
					'right' => array(
						'title' => __( 'Right', 'elementor' ),
						'icon' => 'eicon-text-align-right',
					),
					'justify' => array(
						'title' => __( 'Justified', 'elementor' ),
						'icon' => 'eicon-text-align-justify',
					),
				),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'sub_title',
				'label'   => esc_html__( 'Sub Title', 'gamxo-core' ),
				'default' => esc_html__('ABOUT US', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'title',
				'label'   => esc_html__( 'Title', 'gamxo-core' ),
				'default' => esc_html__( 'Welcome To Gamxo', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXTAREA,
				'id'      => 'sub_content',
				'label'   => esc_html__( 'Sub Content', 'gamxo-core' ),
				'default' => esc_html__('When an unknown printer took a galley of type and scrambled it to make a type survived not only five centuries.', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::WYSIWYG,
				'id'      => 'content',
				'label'   => esc_html__( 'Content', 'gamxo-core' ),
				'default' => esc_html__('Lorem Ipsum has been the industrys standard dummy text ever since printer took a galley. Rimply dummy text of the printing and typesetting industry', 'gamxo-core' ),
			),
			array(
				'type'        => Controls_Manager::SWITCHER,
				'id'          => 'button_display',
				'label'       => esc_html__( 'Button Display', 'gamxo-core' ),
				'label_on'    => esc_html__( 'On', 'gamxo-core' ),
				'label_off'   => esc_html__( 'Off', 'gamxo-core' ),
				'default'     => false,
				'description' => esc_html__( 'Show or Hide Content. Default: off', 'gamxo-core' ),
			),
			array(
				'type'    => Controls_Manager::TEXT,
				'id'      => 'buttontext',
				'label'   => esc_html__( 'Button Text', 'gamxo-core' ),
				'default' => esc_html__( 'Read More', 'gamxo-core' ),
				'condition'   => array( 'button_display' => array( 'yes' ) ),
			),
			array(
				'type'    => Controls_Manager::URL,
				'id'      => 'buttonurl',
				'label'   => esc_html__( 'Button URL', 'gamxo-core' ),
				'placeholder' => 'https://your-link.com',
				'condition'   => array( 'button_display' => array( 'yes' ) ),
			),
			
			array(
				'mode' => 'section_end',
			),
			// Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_title_style',
				'label'   => esc_html__( 'Title Style', 'gamxo-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'title_typo',
				'label'   => esc_html__( 'Title Typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-title-text-button .entry-title',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'title_color',
				'label'   => esc_html__( 'Title Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-title-text-button .entry-title' => 'color: {{VALUE}}',
				),
			),	
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'title_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Title Space', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-title-text-button .entry-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),	
			array(
				'mode' => 'section_end',
			),
			// Sub Title style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_sub_title',
				'label'   => esc_html__( 'Sub Title Style', 'gamxo-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'sub_title_typo',
				'label'   => esc_html__( 'Sub Title Typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-title-text-button .entry-subtitle',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sub_title_color',
				'label'   => esc_html__( 'Sub Title Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-title-text-button .entry-subtitle' => 'color: {{VALUE}}',
				),
			),	
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'sub_title_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Sub Title Space', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-title-text-button .entry-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),
			// Content style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_content_style',
				'label'   => esc_html__( 'Content style', 'gamxo-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'content_typo',
				'label'   => esc_html__( 'Content Typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-title-text-button .entry-content p',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'content_color',
				'label'   => esc_html__( 'Content Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-title-text-button .entry-content p' => 'color: {{VALUE}}',
				),
			),		
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'content_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Content Space', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-title-text-button .entry-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),
			// Sub Content style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_sub_content_style',
				'label'   => esc_html__( 'Sub Content style', 'gamxo-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'sub_content_typo',
				'label'   => esc_html__( 'Sub Content Typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-title-text-button .entry-sub-content p',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'sub_content_color',
				'label'   => esc_html__( 'Sub Content Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-title-text-button .entry-sub-content p' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-title-text-button ul li' => 'color: {{VALUE}}',
				),
			),		
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'sub_content_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Content Space', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-title-text-button .entry-sub-content p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'mode' => 'section_end',
			),
			// Button style
			array(
				'mode'    => 'section_start',
				'id'      => 'sec_button_style',
				'label'   => esc_html__( 'Button Style', 'gamxo-core' ),
				'tab'     => Controls_Manager::TAB_STYLE,
			),
			array (
				'mode'    => 'group',
				'type'    => Group_Control_Typography::get_type(),
				'name'    => 'button_typo',
				'label'   => esc_html__( 'Button Typo', 'gamxo-core' ),
				'selector' => '{{WRAPPER}} .rt-title-text-button .btn-common',
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bag_color',
				'label'   => esc_html__( 'Button Background Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-title-text-button .button-style-2' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_bag_hover_color',
				'label'   => esc_html__( 'Button Background Hover Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-title-text-button .button-style-2:hover' => 'background-color: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_text2_color',
				'label'   => esc_html__( 'Button Text Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-title-text-button .button-style-2' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-title-text-button .button-style-2 path.rt-button-cap' => 'stroke: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::COLOR,
				'id'      => 'button_text2_hover_color',
				'label'   => esc_html__( 'Button Text Hover Color', 'gamxo-core' ),
				'default' => '',
				'selectors' => array(
					'{{WRAPPER}} .rt-title-text-button .button-style-2:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rt-title-text-button .button-style-2:hover path.rt-button-cap' => 'stroke: {{VALUE}}',
				),
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'button_margin',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Button Margin', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-title-text-button .button-style-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),
			array(
				'type'    => Controls_Manager::DIMENSIONS,
				'id'      => 'button_padding',
				'mode'    => 'responsive',
				'label'   => esc_html__( 'Button Padding', 'gamxo-core' ),
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .rt-title-text-button .button-style-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			),		
			array(
				'mode' => 'section_end',
			),
			// Animation style
			array(
	            'mode'    => 'section_start',
	            'id'      => 'sec_animation_style',
	            'label'   => esc_html__( 'Animation', 'gamxo-core' ),
	            'tab'     => Controls_Manager::TAB_STYLE,
	        ),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation',
				'label'   => esc_html__( 'Animation', 'gamxo-core' ),
				'options' => array(
					'wow'        => esc_html__( 'On', 'gamxo-core' ),
					'hide'        => esc_html__( 'Off', 'gamxo-core' ),
				),
				'default' => 'hide',
			),
			array(
				'type'    => Controls_Manager::SELECT2,
				'id'      => 'animation_effect',
				'label'   => esc_html__( 'Entrance Animation', 'gamxo-core' ),
				'options' => array(
                    'none' => esc_html__( 'none', 'gamxo-core' ),
					'bounce' => esc_html__( 'bounce', 'gamxo-core' ),
					'flash' => esc_html__( 'flash', 'gamxo-core' ),
					'pulse' => esc_html__( 'pulse', 'gamxo-core' ),
					'rubberBand' => esc_html__( 'rubberBand', 'gamxo-core' ),
					'shakeX' => esc_html__( 'shakeX', 'gamxo-core' ),
					'shakeY' => esc_html__( 'shakeY', 'gamxo-core' ),
					'headShake' => esc_html__( 'headShake', 'gamxo-core' ),
					'swing' => esc_html__( 'swing', 'gamxo-core' ),					
					'fadeIn' => esc_html__( 'fadeIn', 'gamxo-core' ),
					'fadeInDown' => esc_html__( 'fadeInDown', 'gamxo-core' ),
					'fadeInLeft' => esc_html__( 'fadeInLeft', 'gamxo-core' ),
					'fadeInRight' => esc_html__( 'fadeInRight', 'gamxo-core' ),
					'fadeInUp' => esc_html__( 'fadeInUp', 'gamxo-core' ),					
					'bounceIn' => esc_html__( 'bounceIn', 'gamxo-core' ),
					'bounceInDown' => esc_html__( 'bounceInDown', 'gamxo-core' ),
					'bounceInLeft' => esc_html__( 'bounceInLeft', 'gamxo-core' ),
					'bounceInRight' => esc_html__( 'bounceInRight', 'gamxo-core' ),
					'bounceInUp' => esc_html__( 'bounceInUp', 'gamxo-core' ),			
					'slideInDown' => esc_html__( 'slideInDown', 'gamxo-core' ),
					'slideInLeft' => esc_html__( 'slideInLeft', 'gamxo-core' ),
					'slideInRight' => esc_html__( 'slideInRight', 'gamxo-core' ),
					'slideInUp' => esc_html__( 'slideInUp', 'gamxo-core' ), 
                ),
				'default' => 'fadeInUp',
				'condition'   => array('animation' => array( 'wow' ) ),
			),
			array(
				'mode' => 'section_end',
			),
		);
		return $fields;
	}

	protected function render() {
		$data = $this->get_settings();		

		$template = 'text-with-button';
	
		return $this->rt_template( $template, $data );
	}
}