<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;

use GamxoTheme;
use GamxoTheme_Helper;
use \RT_Postmeta;

if ( ! defined( 'ABSPATH' ) ) exit;

if ( !class_exists( 'RT_Postmeta' ) ) {
	return;
}

$Postmeta = RT_Postmeta::getInstance();

$prefix = GAMXO_CORE_CPT_PREFIX;

/*-------------------------------------
#. Layout Settings
---------------------------------------*/
$nav_menus = wp_get_nav_menus( array( 'fields' => 'id=>name' ) );
$nav_menus = array( 'default' => __( 'Default', 'gamxo-core' ) ) + $nav_menus;
$sidebars  = array( 'default' => __( 'Default', 'gamxo-core' ) ) + GamxoTheme_Helper::custom_sidebar_fields();

$Postmeta->add_meta_box( "{$prefix}_page_settings", __( 'Layout Settings', 'gamxo-core' ), array( 'page', 'post', 'gamxo_team', 'gamxo_service', 'gamxo_case', 'gamxo_testim' ), '', '', 'high', array(
	'fields' => array(
	
		"{$prefix}_layout_settings" => array(
			'label'   => __( 'Layouts', 'gamxo-core' ),
			'type'    => 'group',
			'value'  => array(	
			
				"{$prefix}_layout" => array(
					'label'   => __( 'Layout', 'gamxo-core' ),
					'type'    => 'select',
					'options' => array(
						'default'       => __( 'Default', 'gamxo-core' ),
						'full-width'    => __( 'Full Width', 'gamxo-core' ),
						'left-sidebar'  => __( 'Left Sidebar', 'gamxo-core' ),
						'right-sidebar' => __( 'Right Sidebar', 'gamxo-core' ),
					),
					'default'  => 'default',
				),		
				'gamxo_sidebar' => array(
					'label'    => __( 'Custom Sidebar', 'gamxo-core' ),
					'type'     => 'select',
					'options'  => $sidebars,
					'default'  => 'default',
				),
				"{$prefix}_page_menu" => array(
					'label'    => __( 'Main Menu', 'gamxo-core' ),
					'type'     => 'select',
					'options'  => $nav_menus,
					'default'  => 'default',
				),
				"{$prefix}_top_bar" => array(
					'label' 	  => __( 'Top Bar', 'gamxo-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'on'      => __( 'Enabled', 'gamxo-core' ),
						'off'     => __( 'Disabled', 'gamxo-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_top_bar_style" => array(
					'label' 	=> __( 'Top Bar Layout', 'gamxo-core' ),
					'type'  	=> 'select',
					'options'	=> array(
						'default' => __( 'Default', 'gamxo-core' ),
						'1'       => __( 'Layout 1', 'gamxo-core' ),
						'2'       => __( 'Layout 2', 'gamxo-core' ),
						'3'       => __( 'Layout 3', 'gamxo-core' ),
						'4'       => __( 'Layout 4', 'gamxo-core' ),
					),
					'default'   => 'default',
				),
				"{$prefix}_header_opt" => array(
					'label' 	  => __( 'Header On/Off', 'gamxo-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'on'      => __( 'Enabled', 'gamxo-core' ),
						'off'     => __( 'Disabled', 'gamxo-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_header" => array(
					'label'   => __( 'Header Layout', 'gamxo-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'1'       => __( 'Layout 1', 'gamxo-core' ),
						'2'       => __( 'Layout 2', 'gamxo-core' ),
						'3'       => __( 'Layout 3', 'gamxo-core' ),
						'4'       => __( 'Layout 4', 'gamxo-core' ),
						'5'       => __( 'Layout 5', 'gamxo-core' ),
						'6'       => __( 'Layout 6', 'gamxo-core' ),
						'7'       => __( 'Layout 7', 'gamxo-core' ),
						'8'       => __( 'Layout 8', 'gamxo-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_footer" => array(
					'label'   => __( 'Footer Layout', 'gamxo-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'1'       => __( 'Layout 1', 'gamxo-core' ),
						'2'       => __( 'Layout 2', 'gamxo-core' ),
						'3'       => __( 'Layout 3', 'gamxo-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_footer_area" => array(
					'label' 	  => __( 'Footer Area', 'gamxo-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'on'      => __( 'Enabled', 'gamxo-core' ),
						'off'     => __( 'Disabled', 'gamxo-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_copyright_area" => array(
					'label' 	  => __( 'Copyright Area', 'gamxo-core' ),
					'type'  	  => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'on'      => __( 'Enabled', 'gamxo-core' ),
						'off'     => __( 'Disabled', 'gamxo-core' ),
					),
					'default'  	  => 'default',
				),
				"{$prefix}_top_padding" => array(
					'label'   => __( 'Content Padding Top', 'gamxo-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'0px'     => __( '0px', 'gamxo-core' ),
						'10px'    => __( '10px', 'gamxo-core' ),
						'20px'    => __( '20px', 'gamxo-core' ),
						'30px'    => __( '30px', 'gamxo-core' ),
						'40px'    => __( '40px', 'gamxo-core' ),
						'50px'    => __( '50px', 'gamxo-core' ),
						'60px'    => __( '60px', 'gamxo-core' ),
						'70px'    => __( '70px', 'gamxo-core' ),
						'80px'    => __( '80px', 'gamxo-core' ),
						'90px'    => __( '90px', 'gamxo-core' ),
						'100px'   => __( '100px', 'gamxo-core' ),
						'110px'   => __( '110px', 'gamxo-core' ),
						'120px'   => __( '120px', 'gamxo-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_bottom_padding" => array(
					'label'   => __( 'Content Padding Bottom', 'gamxo-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'0px'     => __( '0px', 'gamxo-core' ),
						'10px'    => __( '10px', 'gamxo-core' ),
						'20px'    => __( '20px', 'gamxo-core' ),
						'30px'    => __( '30px', 'gamxo-core' ),
						'40px'    => __( '40px', 'gamxo-core' ),
						'50px'    => __( '50px', 'gamxo-core' ),
						'60px'    => __( '60px', 'gamxo-core' ),
						'70px'    => __( '70px', 'gamxo-core' ),
						'80px'    => __( '80px', 'gamxo-core' ),
						'90px'    => __( '90px', 'gamxo-core' ),
						'100px'   => __( '100px', 'gamxo-core' ),
						'110px'   => __( '110px', 'gamxo-core' ),
						'120px'   => __( '120px', 'gamxo-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_banner" => array(
					'label'   => __( 'Banner', 'gamxo-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'on'	  => __( 'Enable', 'gamxo-core' ),
						'off'	  => __( 'Disable', 'gamxo-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_breadcrumb" => array(
					'label'   => __( 'Breadcrumb', 'gamxo-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'on'      => __( 'Enable', 'gamxo-core' ),
						'off'	  => __( 'Disable', 'gamxo-core' ),
					),
					'default'  => 'default',
				),
				"{$prefix}_banner_type" => array(
					'label'   => __( 'Banner Background Type', 'gamxo-core' ),
					'type'    => 'select',
					'options' => array(
						'default' => __( 'Default', 'gamxo-core' ),
						'bgimg'   => __( 'Background Image', 'gamxo-core' ),
						'bgcolor' => __( 'Background Color', 'gamxo-core' ),
					),
					'default' => 'default',
				),
				"{$prefix}_banner_bgimg" => array(
					'label' => __( 'Banner Background Image', 'gamxo-core' ),
					'type'  => 'image',
					'desc'  => __( 'If not selected, default will be used', 'gamxo-core' ),
				),
				"{$prefix}_banner_bgcolor" => array(
					'label' => __( 'Banner Background Color', 'gamxo-core' ),
					'type'  => 'color_picker',
					'desc'  => __( 'If not selected, default will be used', 'gamxo-core' ),
				),		
				"{$prefix}_page_bgimg" => array(
					'label' => __( 'Page/Post Background Image', 'gamxo-core' ),
					'type'  => 'image',
					'desc'  => __( 'If not selected, default will be used', 'gamxo-core' ),
				),
				"{$prefix}_page_bgcolor" => array(
					'label' => __( 'Page/Post Background Color', 'gamxo-core' ),
					'type'  => 'color_picker',
					'desc'  => __( 'If not selected, default will be used', 'gamxo-core' ),
				),
			)
		)
	),
) );

/*-------------------------------------
#. Single Post Gallery
---------------------------------------*/

$Postmeta->add_meta_box( 'gamxo_post_info', __( 'Post Info', 'gamxo-core' ), array( 'post' ), '', '', 'high', array(
	'fields' => array(	
		"gamxo_post_layout" => array(
			'label'   => __( 'Post Template', 'gamxo-core' ),
			'type'    => 'select',
			'options' => array(
				'default'  => __( 'Default', 'gamxo-core' ),
				'post-detail-style1'  => __( 'Layout 1', 'gamxo-core' ),
				'post-detail-style2'  => __( 'Layout 2', 'gamxo-core' ),
				'post-detail-style3'  => __( 'Layout 3', 'gamxo-core' ),
			),
			'default'  => 'default',
		),
		"gamxo_youtube_link" => array(
			'label'   => __( 'Youtube Link', 'gamxo-core' ),
			'type'    => 'text',
			'default'  => '',
			'desc'  => __( 'Only work for the video post format', 'gamxo-core' ),
		),	
	),
) );

/*-------------------------------------
#. Team
---------------------------------------*/
$Postmeta->add_meta_box( 'gamxo_team_settings', __( 'Team Member Settings', 'gamxo-core' ), array( 'gamxo_team' ), '', '', 'high', array(
	'fields' => array(
		'gamxo_team_position' => array(
			'label' => __( 'Position', 'gamxo-core' ),
			'type'  => 'text',
		),
		'gamxo_team_website' => array(
			'label' => __( 'Website', 'gamxo-core' ),
			'type'  => 'text',
		),
		'gamxo_team_email' => array(
			'label' => __( 'Email', 'gamxo-core' ),
			'type'  => 'text',
		),
		'gamxo_team_phone' => array(
			'label' => __( 'Phone', 'gamxo-core' ),
			'type'  => 'text',
		),
		'gamxo_team_address' => array(
			'label' => __( 'Address', 'gamxo-core' ),
			'type'  => 'text',
		),
		'gamxo_team_socials_header' => array(
			'label' => __( 'Socials', 'gamxo-core' ),
			'type'  => 'header',
			'desc'  => __( 'Enter your social links here', 'gamxo-core' ),
		),
		'gamxo_team_socials' => array(
			'type'  => 'group',
			'value'  => GamxoTheme_Helper::team_socials()
		),
	)
) );

$Postmeta->add_meta_box( 'gamxo_team_skills', __( 'Team Member Skills', 'gamxo-core' ), array( 'gamxo_team' ), '', '', 'high', array(
	'fields' => array(
		'gamxo_team_skill' => array(
			'type'  => 'repeater',
			'button' => __( 'Add New Skill', 'gamxo-core' ),
			'value'  => array(
				'skill_name' => array(
					'label' => __( 'Skill Name', 'gamxo-core' ),
					'type'  => 'text',
					'desc'  => __( 'eg. Marketing', 'gamxo-core' ),
				),
				'skill_value' => array(
					'label' => __( 'Skill Percentage (%)', 'gamxo-core' ),
					'type'  => 'text',
					'desc'  => __( 'eg. 75', 'gamxo-core' ),
				),
				'skill_color' => array(
					'label' => __( 'Skill Color', 'gamxo-core' ),
					'type'  => 'color_picker',
					'desc'  => __( 'If not selected, primary color will be used', 'gamxo-core' ),
				),
			)
		),
	)
) );
$Postmeta->add_meta_box( 'gamxo_team_contact', __( 'Team Member Contact', 'gamxo-core' ), array( 'gamxo_team' ), '', '', 'high', array(
	'fields' => array(
		'gamxo_team_contact_form' => array(
			'label' => __( 'Contct Shortcode', 'gamxo-core' ),
			'type'  => 'text',
		),
	)
) );