<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

namespace radiustheme\Gamxo_Core;
use \RT_Posts;
use GamxoTheme;


if ( !class_exists( 'RT_Posts' ) ) {
	return;
}

$post_types = array(
	'gamxo_team'       => array(
		'title'           => __( 'Team Member', 'gamxo-core' ),
		'plural_title'    => __( 'Team', 'gamxo-core' ),
		'menu_icon'       => 'dashicons-businessman',
		'labels_override' => array(
			'menu_name'   => __( 'Team', 'gamxo-core' ),
		),
		'rewrite'         => GamxoTheme::$options['team_slug'],
		'supports'        => array( 'title', 'thumbnail', 'editor', 'excerpt', 'page-attributes' )
	),
);

$taxonomies = array(
	'gamxo_team_category' => array(
		'title'        => __( 'Team Category', 'gamxo-core' ),
		'plural_title' => __( 'Team Categories', 'gamxo-core' ),
		'post_types'   => 'gamxo_team',
		'rewrite'      => array( 'slug' => GamxoTheme::$options['team_cat_slug'] ),
	),
);

$Posts = RT_Posts::getInstance();
$Posts->add_post_types( $post_types );
$Posts->add_taxonomies( $taxonomies );