<?php

/**
 *
 * Get Errin Theme options
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! function_exists( 'errin_get_option' ) ) {
	function errin_get_option( $option = '', $default = null ) {
		$options = get_option( 'errin_theme_options' ); // Attention: Set your unique id of the framework
		return ( isset( $options[$option] ) ) ? $options[$option] : $default;
	}
}

/**
 *
 * Get get switcher option
 *  for theme options
 * @since 1.0.0
 * @version 1.0.0
 *
 */

if ( ! function_exists( 'errin_get_switcher_option' )) {

	function errin_get_switcher_option( $option = '', $default = null ) {
		$options = get_option( 'errin_theme_options' ); // Attention: Set your unique id of the framework
		$return_val =  ( isset( $options[$option] ) ) ? $options[$option] : $default;
		$return_val =  (is_null($return_val) || '1' == $return_val ) ? true : false;;
		return $return_val;
	}
}

if ( ! function_exists( 'errin_switcher_option' )) {

	function errin_switcher_option( $option = '', $default = null ) {
		$options = get_option( 'errin_theme_options' ); // Attention: Set your unique id of the framework
		$return_val =  ( isset( $options[$option] ) ) ? $options[$option] : $default;
		$return_val =  ( '1' == $return_val ) ? true : false;;
		return $return_val;
	}
}

/**
 *
 * Get customize option
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */

if ( ! function_exists( 'errin_get_customize_option' ) ) {

	function errin_get_customize_option( $option = '', $default = null ) {
		$options = get_option( 'errin_customize_options' ); // Attention: Set your unique id of the framework
		return ( isset( $options[$option] ) ) ? $options[$option] : $default;
	}
}